IF EXISTS (SELECT * FROM sys.objects WHERE
						object_id = OBJECT_ID(N'[dbo].[P_PDV_VD_MOVIMENTO_RELATORIOS_PROC]') AND
						type IN ( N'P', N'PC' ))
	BEGIN
		DROP PROCEDURE [dbo].[P_PDV_VD_MOVIMENTO_RELATORIOS_PROC]
	END

GO

--EXEC P_PDV_VD_MOVIMENTO_RELATORIOS_PROC 1,1,'2018-06-21','2018-06-21'
CREATE PROCEDURE [dbo].[P_PDV_VD_MOVIMENTO_RELATORIOS_PROC] (@CD_EMP    INT,
																@CD_FILIAL INT,
																@DT_INI    DATETIME,
																@DT_FIM    DATETIME)
 
AS
	SET NOCOUNT ON
	SET ANSI_WARNINGS OFF; 
 
	DECLARE @FLAG_IGNORA_FECH_CAIXA_PROC_REL VARCHAR(255)

	SET @FLAG_IGNORA_FECH_CAIXA_PROC_REL = COALESCE((SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE = 'FLAG_IGNORA_FECH_CAIXA_PROC_REL'), '0')

	IF @FLAG_IGNORA_FECH_CAIXA_PROC_REL = '0'
	BEGIN
		if Exists (select * from pdv_vd_fecha_mov
				where
					BLQ_ALT_FECHA =1
					and CD_EMP    = @CD_EMP 
					AND CD_FILIAL = @CD_FILIAL 
					AND DT_MOV BETWEEN @DT_INI AND @DT_FIM  )
		begin
			Print 'Consta movimento de caixa bloqueado para o periodo e filial requisitado'
			return;
		end
	END

	DELETE FROM PDV_VD_MOVIMENTO_RELATORIOS
	WHERE  CD_EMP    = @CD_EMP AND
					CD_FILIAL = @CD_FILIAL AND
					DT_MOV BETWEEN @DT_INI AND @DT_FIM option (recompile);

	INSERT INTO PDV_VD_MOVIMENTO_RELATORIOS
							(CD_EMP,
								CD_FILIAL,
								DT_MOV,
								VLR_VENDA_MOVIMENTO,
								VLR_VENDA_RELATORIO,
								VLR_VENDA_LEITURA_Z,
								DT_ULT_CONSD,
								QT_CUPOM_MATRIZ,
								QT_CUPOM_LOJA,
								QT_NAO_CUPOM_MATRIZ,
								QT_NAO_CUPOM_LOJA)	
	SELECT
		CD_EMP,
		CD_FILIAL,
		DTMOVIMENTO,
		SUM(VlrVendasPDV) AS VLR_VENDA_MOVIMENTO,
		SUM(VlrVdProcessado) AS VLR_VENDA_RELATORIO,
		SUM(VLR_VENDA_LEITURA_Z) AS VLR_VENDA_LEITURA_Z,
		MAX(DT_ULT_CONSD),
		SUM(QT_CUPOM_MATRIZ),
		SUM(QT_CUPOM_LOJA),
		SUM(QT_NAO_CUPOM_MATRIZ),
		SUM(QT_NAO_CUPOM_LOJA)			
	FROM
	(SELECT 
		EST_MOVIMENTO_VENDAS.CD_EMP,
		EST_MOVIMENTO_VENDAS.CD_FILIAL,
		GLB_DT_MOVIMENTO.DT_MOVIMENTO as DtMovimento,
		SUM(EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD_LIQ) AS VlrVdProcessado,
		0 AS VlrVendasPDV,
		0 AS VLR_VENDA_LEITURA_Z,
		NULL DT_ULT_CONSD,
		0 AS QT_CUPOM_MATRIZ,
		0 AS QT_CUPOM_LOJA,
		0 AS QT_NAO_CUPOM_MATRIZ,
		0 AS QT_NAO_CUPOM_LOJA
	FROM            
		EST_MOVIMENTO_VENDAS_PRODUTOS INNER JOIN EST_MOVIMENTO_VENDAS ON EST_MOVIMENTO_VENDAS_PRODUTOS.CD_EMP = EST_MOVIMENTO_VENDAS.CD_EMP
		and EST_MOVIMENTO_VENDAS_PRODUTOS.CD_CTR_VENDAS = EST_MOVIMENTO_VENDAS.CD_CTR_VENDAS
		INNER JOIN GLB_DT_MOVIMENTO ON
		EST_MOVIMENTO_VENDAS.CD_CTR_DT_MOVIMENTO = GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
	WHERE
		EST_MOVIMENTO_VENDAS.TIPO_VENDA =0
		AND EST_MOVIMENTO_VENDAS.CD_EMP = @CD_EMP
		AND EST_MOVIMENTO_VENDAS.CD_FILIAL=@CD_FILIAL
		AND GLB_DT_MOVIMENTO.DT_MOVIMENTO BETWEEN @DT_INI AND @DT_FIM 
	group by 
		EST_MOVIMENTO_VENDAS.CD_EMP,
		EST_MOVIMENTO_VENDAS.CD_FILIAL,
		GLB_DT_MOVIMENTO.DT_MOVIMENTO
	UNION ALL
	SELECT 
		CD_EMP,
		CD_FILIAL,
		DT_VD,
		0 AS VlrVdProcessado,
		VLR_LIQ_VD as VlrVendasPDV,
		0 AS VLR_VENDA_LEITURA_Z,
		NULL DT_ULT_CONSD,
		0 AS QT_CUPOM_MATRIZ,
		0 AS QT_CUPOM_LOJA,
		0 AS QT_NAO_CUPOM_MATRIZ,
		0 AS QT_NAO_CUPOM_LOJA	
	FROM 
		PDV_VD 
	WHERE 
		PDV_VD.CD_EMP = @CD_EMP
		AND PDV_VD.CD_FILIAL=@CD_FILIAL
		AND PDV_VD.DT_VD BETWEEN @DT_INI AND @DT_FIM 
		AND PDV_VD.ST_VD=0
	UNION ALL
		SELECT
			CD_EMP,
			CD_FILIAL,
			DT_MOV,
			0 AS VlrVdProcessado,
			0 as VlrVendasPDV,
			ROUND(VLR_LEITUR_Z,2) + ROUND(VLR_PDV_VD_ISSQN,2) AS VLR_VENDA_LEITURA_Z,
			DT_ULT_CONSD,
			QT_CUPOM_MATRIZ,
			QT_CUPOM_LOJA,
			QT_NAO_CUPOM_MATRIZ,
			QT_NAO_CUPOM_LOJA				
		FROM
			PDV_CONSLD_VD_MOVIMENTO
		WHERE 
			PDV_CONSLD_VD_MOVIMENTO.CD_EMP = @CD_EMP
			AND PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL=@CD_FILIAL
			AND PDV_CONSLD_VD_MOVIMENTO.DT_MOV BETWEEN @DT_INI AND @DT_FIM) Rs
	group by
		CD_EMP,
		CD_FILIAL,
		DTMOVIMENTO;